#include <winsock2.h>

// Some other standard libraries i'll use
#include <iostream>
using namespace std;


int main() 
{
	cout << "Part 1: Creating a Socket!\n";
	cout << "CelestialKey Tutorial \n\n";

	int error; // Used to return any errors found. Only needed for debugging purposes.

	WSAData wsaData; // This holds information about our network, we wont use this really, its mostly there for completeness

	error = WSAStartup(MAKEWORD(2, 2), &wsaData); // Make a call to start up winsock, MAKEWORD simply tells the version we are going to us. Version 2.2 for us

	if (error == SOCKET_ERROR)  // Almost EVERY Winsock function will reutrn a number on error, so we should always check for errors
	{
		cout << "Server: We Errored Starting Winsock!!!\n";
		return 1;
	}

	cout << "Server: WinSock Successfully Started.\n"; // Good so far!

	int mySocket; // We will use this one to talk to another computer

	mySocket = socket(AF_INET, SOCK_STREAM, 0); // We make it. Just know, AF_INET means set up for the internet, SOCK_STREAM means a streaming socket (connection),
                                                                                        // you could aslo have used SOCK_DGRAM (connectionless). But that causes alot fo problems, so we wont use it. 
                                                                                        // The 0 is there for a extra qualifier, we WONT use this, we just pass 0 to complete it


	if (mySocket == SOCKET_ERROR) 
	{
		cout << "Server: Error Something Bad Happened!\n";
	}

	cout << "Server: Doing Good...\n";

	closesocket(mySocket); // Now we need to close our socket.

	cout << "Server: Socket Closed!\n";


	WSACleanup(); // This is called to shut down the dll we loaded earlier. If we dont do this, we get memory leaks, not pretty.

	cout << "Server: WinSock shut down successfully!\n";
	return 0;

}
